% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcrPlate-input.R
\name{pcrPlateInput}
\alias{pcrPlateInput}
\title{Create a PCR plate input control}
\usage{
pcrPlateInput(inputId,
       label = NULL,
       plateDescription,
       pcrFormat = pcrFormatType$new(8, 12, labelFormatType$new("ABC"),
        labelFormatType$new("123")),
       selection = NULL,
       highlighting = NULL,
       wellLabelTemplate = "{{sample}}",
       onHoverWellTextTemplate = "{{position}}\u000A{{sample}}\u000A{{targets}}",
       wellClassTemplate = NULL,
       wellStyleTemplate = NULL,
       wellGroupTemplate = "{{sample}}-{{targets}}",
       cssFile = system.file("/css/pcrPlateInputStyle.css",
                 package = "shinyMolBio"),
       cssText = NULL,
       legend = NULL,
       interactive = TRUE)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the selected
wells positions.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{plateDescription}{Plate description - basicly output from \code{RDML
AsTable()} function.}

\item{pcrFormat}{PCR plate parametrs. Should be \code{pcrFormatType}.}

\item{selection}{Set preselected wells (e.g. \code{c("A01", "A02")} or \code{c(1, 2)})}

\item{highlighting}{Set highlighted wells (e.g. \code{c("A01", "A02")} or \code{c(1, 2)})}

\item{wellLabelTemplate}{Template of the well label.}

\item{onHoverWellTextTemplate}{Template of the text on hover.}

\item{wellClassTemplate}{Template of the well class (css class).}

\item{wellStyleTemplate}{Template of the well style (css).}

\item{wellGroupTemplate}{Template of the well group for selecting.}

\item{cssFile}{Path to the css styles file.}

\item{cssText}{CSS styles as text.}

\item{legend}{Plate legend (any HTML content).}

\item{interactive}{Should be this \code{pcrPlate} interactive or not.}
}
\value{
A PCR plate control that can be added to a UI definition.
}
\description{
Create an input control for representing PCR plate and dynamically selecting
wells inside it.
}
\examples{
## Only run examples in interactive R sessions
library(RDML)
if (interactive()) {
ui <- fluidPage(
    pcrPlateInput("plate1",
                   "Plate 1",
                   RDML$new(system.file("/extdata/stepone_std.rdml", package = "RDML"))$AsTable(),
                  pcrFormatType$new(8,12,labelFormatType$new("ABC"),
                                         labelFormatType$new("123"))),
   verbatimTextOutput("selected")
 )
 server <- function(input, output) {
   output$selected <- renderText({ input$plate1 })
 }
 shinyApp(ui, server)
}
}
\seealso{
\code{\link{updatePcrPlateInput}}
}
\author{
Konstantin A. Blagodatskikh <k.blag@yandex.ru>
}
\concept{input elements}
\keyword{Input}
\keyword{PCR}
\keyword{RDML}
\keyword{Shiny}
