% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils__url.R
\name{is_ok_host}
\alias{is_ok_host}
\title{Check if URL(s) are HTTPS and/or in allowed hosts lists}
\usage{
is_ok_host(
  url,
  allowed_non_https_hosts = getOption("shinyOAuth.allowed_non_https_hosts", default =
    c("localhost", "127.0.0.1", "::1", "[::1]")),
  allowed_hosts = getOption("shinyOAuth.allowed_hosts", default = NULL)
)
}
\arguments{
\item{url}{Single URL or vector of URLs (character; length 1 or more)}

\item{allowed_non_https_hosts}{Character vector of hostnames that are allowed
to use HTTP instead of HTTPS. Defaults to localhost equivalents. Supports globs}

\item{allowed_hosts}{Optional allowlist of hosts/domains; if supplied (length > 0),
only these hosts are permitted. Supports globs}
}
\value{
Logical indicator (TRUE if all URLs pass all checks; FALSE otherwise)
}
\description{
Returns TRUE if every input URL is either:
\itemize{
\item a syntactically valid HTTPS URL, and (if set) whose host matches \code{allowed_hosts}, or
\item an HTTP URL whose host matches \code{allowed_non_https_hosts} (e.g. localhost, 127.0.0.1, ::1),
and (if set) also matches \code{allowed_hosts}.
}

If the input omits the scheme (e.g., "localhost:8080/cb"), this function
will first attempt to validate it as HTTP (useful for loopback development),
and if that fails, as HTTPS. This mirrors how helpers normalize inputs for
convenience while still enforcing the same host and scheme policies.

\code{allowed_hosts} is thus an allowlist of hosts/domains that are permitted, while
\code{allowed_non_https_hosts} defines which hosts are allowed to use HTTP instead of HTTPS.
If \code{allowed_hosts} is NULL or length 0, all hosts are allowed (subject to scheme rules),
but HTTPS is still required unless the host is in \code{allowed_non_https_hosts}.

Since \code{allowed_hosts} supports globs, a value like "*" matches any host
and therefore effectively disables endpoint host restrictions. Only use a catch‑all
pattern when you truly intend to allow any host. In most deployments you should pin
to your expected domain(s), e.g. \code{c(".example.com")} or a specific host name.

Wildcards: \code{allowed_hosts} and \code{allowed_non_https_hosts} support globs:
\code{*} = any chars, \verb{?} = one char. A leading \code{.example.com} matches the
domain itself and any subdomain.

Any non-URLs, NAs, or empty strings cause a FALSE result.
}
\details{
This function is used internally to validate redirect URIs in OAuth clients,
but can be used elsewhere to test if URLs would be allowed. Internally, it will always
determine the default values for \code{allowed_non_https_hosts} and \code{allowed_hosts}
from the options \code{shinyOAuth.allowed_non_https_hosts} and
\code{shinyOAuth.allowed_hosts}, respectively.
}
\examples{
# HTTPS allowed by default
is_ok_host("https://example.com")

# HTTP allowed for localhost
is_ok_host("http://localhost:8100")

# Restrict to a specific domain (allowlist)
is_ok_host("https://api.example.com", allowed_hosts = c(".example.com"))

# Caution: a catch-all pattern disables host restrictions
# (only scheme rules remain). Avoid unless you truly intend it
is_ok_host("https://anywhere.example", allowed_hosts = c("*"))
}
