% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationParms.R
\name{link2input}
\alias{link2input}
\title{Convert Browser Location Parameters to Shiny Input and Output Values}
\usage{
link2input(..., inputtype = "default", session = getDefaultReactiveDomain())
}
\arguments{
\item{...}{List of Shiny input IDs to match with window location parameters}

\item{inputtype}{Type of inputs being included}

\item{session}{Shiny session object}
}
\value{
Setting of the Shiny inputs to the values of the parameters in the browser link
}
\description{
Parse the browser link and retrieve parameters for inclusion as values in inputs or outputs
}
\note{
a great example of how to use this functionality can be found in https://cran.r-project.org/web/packages/shinyStorePlus/vignettes/shinystoreplus_v08.html
}
\examples{
if (interactive()) {
  # within the server function
  server <- function(input, output, session) {
    link2input(
      cd323 = "name",
      datasetbin = "data",
      numberid = "num"
    )

    link2input(
      outputid = "outt",
      inputtype = "output"
    )
  }
}
}
