% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-time.R
\name{updateTimeInput}
\alias{updateTimeInput}
\title{Change a time input on the client}
\usage{
updateTimeInput(session, inputId, label = NULL, value = NULL)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The desired time value. Must be a instance of \code{\link{DateTimeClasses}}.}
}
\description{
Change the label and/or value of a time input
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  timeInput("time", "Time:"),
  actionButton("to_current_time", "Current time")
)

server <- function(input, output, session) {
  observeEvent(input$to_current_time, {
    updateTimeInput(session, "time", value = Sys.time())
  })
}

shinyApp(ui, server)
}

}
\seealso{
Other shinyTime functions: \code{\link{shinyTimeExample}},
  \code{\link{timeInput}}
}
\concept{shinyTime functions}
