% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-pretty.R
\name{updatePrettySwitch}
\alias{updatePrettySwitch}
\title{Change the value of a pretty switch on the client}
\usage{
updatePrettySwitch(session, inputId, label = NULL, value = NULL)
}
\arguments{
\item{session}{The session object passed to function given to shinyServer.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}
}
\description{
Change the value of a pretty switch on the client
}
\examples{
library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h1("Pretty switch update value"),
  br(),

  prettySwitch(inputId = "switch1", label = "Update me !"),
  verbatimTextOutput(outputId = "res1"),
  radioButtons(
    inputId = "update",
    label = "Value to set:",
    choices = c("FALSE", "TRUE")
  )

)

server <- function(input, output, session) {

  output$res1 <- renderPrint(input$switch1)

  observeEvent(input$update, {
    updatePrettySwitch(
      session = session,
      inputId = "switch1",
      value = as.logical(input$update)
    )
  })

}

if (interactive())
  shinyApp(ui, server)
}
