% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-search.R
\name{searchInput}
\alias{searchInput}
\title{Search Input}
\usage{
searchInput(
  inputId,
  label = NULL,
  value = "",
  placeholder = NULL,
  btnSearch = NULL,
  btnReset = NULL,
  resetValue = "",
  width = NULL
)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{Display label for the control, or NULL for no label.}

\item{value}{Initial value.}

\item{placeholder}{A character string giving the user a hint as to what can be entered into the control.}

\item{btnSearch}{An icon for the button which validate the search.}

\item{btnReset}{An icon for the button which reset the search.}

\item{resetValue}{Value used when reset button is clicked, default to \code{""},
if \code{NULL} value is not reset.}

\item{width}{The width of the input, e.g. \verb{400px}, or \verb{100\%}.}
}
\description{
A text input only triggered when Enter key is pressed or search button clicked
}
\note{
The two buttons ('search' and 'reset') act like \code{actionButton}, you can
retrieve their value server-side with \code{input$<INPUTID>_search} and \code{input$<INPUTID>_reset}.
}
\examples{
if (interactive()) {
  ui <- fluidPage(
    tags$h1("Search Input"),
    br(),
    searchInput(
      inputId = "search", label = "Enter your text",
      placeholder = "A placeholder",
      btnSearch = icon("magnifying-glass"),
      btnReset = icon("xmark"),
      width = "450px"
    ),
    br(),
    verbatimTextOutput(outputId = "res")
  )

  server <- function(input, output, session) {
    output$res <- renderPrint({
      input$search
    })
  }

  shinyApp(ui = ui, server = server)
}

}
\seealso{
\link{updateSearchInput} to update value server-side.
}
