% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterInput.R, R/updateFilterInput.R
\name{call_input_function}
\alias{call_input_function}
\alias{call_filter_input}
\alias{call_update_filter_input}
\title{Prepare and Evaluate Input Function and Arguments}
\usage{
call_filter_input(x, .f, ...)

call_update_filter_input(x, .f, ...)
}
\arguments{
\item{x}{The object being passed to \code{\link[=filterInput]{filterInput()}}.}

\item{.f}{The input function to be called.}

\item{...}{Arguments passed to either \code{\link[=args_filter_input]{args_filter_input()}} or provided
input function.}
}
\value{
The result of calling the provided input function.
}
\description{
Internal function used to prepare input arguments using
\code{\link[=args_filter_input]{args_filter_input()}}, and gracefully pass them to provided input function.
}
\details{
\code{call_filter_input()} and \code{call_update_filter_input()} are used when
customizing \pkg{shinyfilters}. For more, see
\code{vignette("customizing-shinyfilters")}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(S7)
library(shiny)
# call_filter_input() is used inside filterInput() methods
method(filterInput, class_numeric) <- function(x, ...) {
  call_filter_input(x, sliderInput, ...)
}

# call_update_filter_input() is used inside updateFilterInput() methods
method(updateFilterInput, class_numeric) <- function(x, ...) {
  call_update_filter_input(x, updateSliderInput, ...)
}
\dontshow{\}) # examplesIf}
}
