% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsFunc-visibilityFuncs.R
\name{visibilityFuncs}
\alias{hide}
\alias{show}
\alias{toggle}
\alias{visibilityFuncs}
\title{Display/hide an element}
\usage{
show(id, anim, animType, time, selector)

hide(id, anim, animType, time, selector)

toggle(id, anim, animType, time, selector, condition)
}
\arguments{
\item{id}{The id of the element/Shiny tag}

\item{anim}{If \code{TRUE} then animate the behaviour (default: \code{FALSE})}

\item{animType}{The type of animation to use, either \code{"slide"} or \code{"fade"}
(default: \code{"slide"})}

\item{time}{The number of seconds to make the animation last (default: \code{0.5})}

\item{selector}{JQuery selector of the elements to show/hide. Ignored if the
\code{id} argument is given. For example, to select all span elements with
class x, use \code{selector = "span.x"}}

\item{condition}{An optional argument to \code{toggle}, see 'Details' below.}
}
\description{
Display or hide an HTML element.\cr\cr
\strong{\code{show}} makes an element visible, \strong{\code{hide}} makes
an element invisible, \strong{\code{toggle}} displays the element if it it
hidden and hides it if it is visible.\cr\cr
If \code{condition} is given to \code{toggle}, that condition will be used
to determine if to show or hide the element. The element will be shown if the
condition evaluates to \code{TRUE} and hidden otherwise. If you find
yourself writing code such as \code{if (test()) show(id) else hide(id)}
then you can use \code{toggle} instead: \code{toggle(id = id, condition = test())}.
}
\details{
If you want to hide/show an element in a few seconds rather than immediately,
you can use the \code{\link[shinyjs]{delay}} function.
}
\note{
\code{shinyjs} must be initialized with a call to \code{useShinyjs()}
in the app's ui.
}
\examples{
if (interactive()) {
  library(shiny)

  shinyApp(
    ui = fluidPage(
      useShinyjs(),  # Set up shinyjs
      actionButton("btn", "Click me"),
      textInput("text", "Text")
    ),
    server = function(input, output) {
      observeEvent(input$btn, {
        # Change the following line for more examples
        toggle("text")
      })
    }
  )
}
\dontrun{
  # The shinyjs function call in the above app can be replaced by
  # any of the following examples to produce similar Shiny apps
  toggle(id = "text")
  delay(1000, toggle(id = "text")) # toggle in 1 second
  toggle("text", TRUE)
  toggle("text", TRUE, "fade", 2)
  toggle(id = "text", time = 1, anim = TRUE, animType = "slide")
  show("text")
  show(id = "text", anim = TRUE)
  hide("text")
  hide(id = "text", anim = TRUE)
}

## toggle can be given an optional `condition` argument, which
## determines if to show or hide the element
if (interactive()) {
  shinyApp(
    ui = fluidPage(
      useShinyjs(),
      checkboxInput("checkbox", "Show the text", TRUE),
      p(id = "element", "Watch what happens to me")
    ),
    server = function(input, output) {
      observe({
        toggle(id = "element", condition = input$checkbox)
      })
    }
  )
}
}
\seealso{
\code{\link[shinyjs]{useShinyjs}},
\code{\link[shinyjs]{runExample}},
\code{\link[shinyjs]{hidden}},
\code{\link[shinyjs]{delay}}
}

