% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shorts-S3.R
\name{plot.shorts_fv_profile}
\alias{plot.shorts_fv_profile}
\title{S3 method for plotting \code{shorts_fv_profile} object}
\usage{
\method{plot}{shorts_fv_profile}(x, type = "velocity", ...)
}
\arguments{
\item{x}{\code{shorts_fv_profile} object}

\item{type}{Type of plot. Options are "velocity" (default) and "time"}

\item{...}{Not used}
}
\value{
\link[ggplot2]{ggplot} object
}
\description{
S3 method for plotting \code{shorts_fv_profile} object
}
\examples{
data("jb_morin")

m1 <- model_radar_gun(time = jb_morin$time, velocity = jb_morin$velocity)

fv_profile <- make_FV_profile(
  MSS = m1$parameters$MSS,
  MAC = m1$parameters$MAC,
  bodyheight = 1.72,
  bodymass = 120
)

plot(fv_profile)
plot(fv_profile, "time")
}
