% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-FV-profile.R
\name{make_FV_profile}
\alias{make_FV_profile}
\title{Get Force-Velocity Profile}
\usage{
make_FV_profile(MSS, MAC, bodymass = 75, inertia = 0, resistance = 0, ...)
}
\arguments{
\item{MSS, MAC}{Numeric vectors. Model parameters}

\item{bodymass}{Body mass in kg. Used to calculate relative power and forwarded to \code{\link{get_air_resistance}}}

\item{inertia}{External inertia in kg (for example a weight vest, or a sled).
Not included in the air resistance calculation}

\item{resistance}{External horizontal resistance in Newtons (for example tether device or a sled friction resistance)}

\item{...}{Forwarded to \code{\link{get_air_resistance}} for the purpose of calculation of air resistance and power}
}
\value{
List containing the following elements:
    \describe{
        \item{bodymass}{Returned \code{bodymass} used in FV profiling}
        \item{F0}{Horizontal force when velocity=0}
        \item{F0_rel}{\code{F0} divided by \code{bodymass}}
        \item{V0}{Velocity when horizontal force=0}
        \item{Pmax}{Maximal horizontal power}
        \item{Pmax_rel}{\code{Pmax} divided by \code{bodymass}}
        \item{FV_slope}{Slope of the FV profile. See References for more info}
    }
}
\description{
Provides Force-Velocity (FV) profile modified using ideas by Pierre Samozino and JB-Morin, et al. (2016) and
   Pierre Samozino and Nicolas Peyror, et al (2021).
}
\examples{
data("jb_morin")

m1 <- model_radar_gun(time = jb_morin$time, velocity = jb_morin$velocity)

fv_profile <- make_FV_profile(
  MSS = m1$parameters$MSS,
  MAC = m1$parameters$MAC,
  bodyheight = 1.72,
  bodymass = 120,

)

fv_profile
}
\references{
Samozino P, Rabita G, Dorel S, Slawinski J, Peyrot N, Saez de Villarreal E, Morin J-B. 2016.
    A simple method for measuring power, force, velocity properties, and mechanical effectiveness in
    sprint running: Simple method to compute sprint mechanics. Scandinavian Journal of Medicine & Science
    in Sports 26:648–658. DOI: 10.1111/sms.12490.

    Samozino P, Peyrot N, Edouard P, Nagahara R, Jimenez‐Reyes P, Vanwanseele B, Morin J. 2022.
     Optimal mechanical force‐velocity profile for sprint acceleration performance.
      Scandinavian Journal of Medicine & Science in Sports 32:559–575. DOI: 10.1111/sms.14097.
}
