% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_functions.R
\name{gen_posterior_samples}
\alias{gen_posterior_samples}
\title{Generate Posterior Samples}
\usage{
gen_posterior_samples(mod, nsamp = 1000)
}
\arguments{
\item{mod}{A \code{shrinkGPR} object representing the fitted Gaussian process regression model.}

\item{nsamp}{Positive integer specifying the number of posterior samples to generate. Default is 1000.}
}
\value{
A list containing posterior samples of the model parameters:
\itemize{
\item \code{thetas}: A matrix of posterior samples for the inverse lengthscale parameters.
\item \code{sigma2}: A matrix of posterior samples for the noise variance.
\item \code{lambda}: A matrix of posterior samples for the global shrinkage parameter.
\item \code{betas} (optional): A matrix of posterior samples for the mean equation parameters (if included in the model).
\item \code{lambda_mean} (optional): A matrix of posterior samples for the mean equation's global shrinkage parameter (if included in the model).
}
}
\description{
\code{gen_posterior_samples} generates posterior samples of the model parameters from a fitted \code{shrinkGPR} or \code{shrinkTPR} model.
}
\details{
This function draws posterior samples from the latent space and transforms them into the parameter space of the model. These samples can be used for posterior inference or further analysis.
}
\examples{
\donttest{
if (torch::torch_is_installed()) {
  # Simulate data
  set.seed(123)
  torch::torch_manual_seed(123)
  n <- 100
  x <- matrix(runif(n * 2), n, 2)
  y <- sin(2 * pi * x[, 1]) + rnorm(n, sd = 0.1)
  data <- data.frame(y = y, x1 = x[, 1], x2 = x[, 2])

  # Fit GPR model
  res <- shrinkGPR(y ~ x1 + x2, data = data)

  # Generate posterior samples
  samps <- gen_posterior_samples(res, nsamp = 1000)

  # Plot the posterior samples
  boxplot(samps$thetas)
  }
}
}
