% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{sg_export_svg}
\alias{sg_export_svg}
\alias{sg_export_img}
\alias{sg_export_img_p}
\alias{sg_export_svg_p}
\title{Export}
\usage{
sg_export_svg(sg, download = TRUE, file = "graph.svg", size = 1000,
  width = 1000, height = 1000, labels = FALSE, data = FALSE)

sg_export_img(sg, download = TRUE, file = "graph.png",
  background = "white", format = "png", labels = FALSE)

sg_export_img_p(proxy, download = TRUE, file = "graph.png",
  background = "white", format = "png", labels = FALSE)

sg_export_svg_p(proxy, download = TRUE, file = "graph.svg",
  size = 1000, width = 1000, height = 1000, labels = FALSE,
  data = FALSE)
}
\arguments{
\item{sg}{An object of class \code{sigmajs}as intatiated by \code{\link{sigmajs}}.}

\item{download}{set to \code{TRUE} to download.}

\item{file}{Name of file.}

\item{size}{Size of the SVG in pixels.}

\item{width, height}{Width and height of the SVG in pixels.}

\item{labels}{Whether the labels should be included in the svg file.}

\item{data}{Whether additional data (node ids for instance) should be included in the svg file.}

\item{background}{Background color of image.}

\item{format}{Format of image, takes \code{png}, \code{jpg}, \code{gif} or \code{tiff}.}

\item{proxy}{An object of class \code{sigmajsProxy} as returned by \code{\link{sigmajsProxy}}.}
}
\description{
Export graph to SVG.
}
\examples{
nodes <- sg_make_nodes() 
edges <- sg_make_edges(nodes, 17)

sigmajs() \%>\% 
  sg_nodes(nodes, id, size) \%>\% 
  sg_edges(edges, id, source, target) \%>\% 
  sg_export_svg() \%>\% 
  sg_button("download", "export_svg")

# demo("export-graph", package = "sigmajs")

}
