% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_series.R
\name{prepare_copynumber}
\alias{prepare_copynumber}
\title{Prepare nmf input matrix for copy number signature analysis}
\usage{
prepare_copynumber(CopyNumber, reference_components = FALSE, cores = 1,
  seed = 123456, min_comp = 2, max_comp = 10, min_prior = 0.001,
  model_selection = "BIC", nrep = 1, niter = 1000, rowIter = 1000)
}
\arguments{
\item{CopyNumber}{a \link{CopyNumber} object.}

\item{reference_components}{default is \code{FALSE}, calculate mixture components
from \link{CopyNumber} object.
If set it to \code{NULL}, use pre-compiled components data which come from
\href{https://www.nature.com/articles/s41588-018-0179-8}{CNV signature paper}.
If can also be a \code{list} contain flexmix object of copy-number features,
obtain this from \link{get_components} function.}

\item{cores}{number of compute cores to run this task.
You can use \code{\link[parallel:detectCores]{parallel::detectCores()}} function to check how
many cores you can use.}

\item{seed}{seed number.}

\item{min_comp}{minimal number of components to fit, default is 2.
Can also be a vector with length 6, which apply to each feature.}

\item{max_comp}{maximal number of components to fit, default is 10.
Can also be a vector with length 6, which apply to each feature.}

\item{min_prior}{minimal prior value, default is 0.001.
Details about custom setting please refer to \strong{flexmix} package.}

\item{model_selection}{model selection strategy, default is 'BIC'.
Details about custom setting please refer to \strong{flexmix} package.}

\item{nrep}{number of run times for each value of component,
keep only the solution with maximum likelihood.}

\item{niter}{maximal number of iteration to achive converge.}

\item{rowIter}{step size of iteration for rows of ech CNV feature.}
}
\value{
a \code{list} contains \code{matrix} for NMF input, copy number features and components.
}
\description{
Prepare nmf input matrix for copy number signature analysis
}
\examples{
\donttest{
# Load copy number object
load(system.file("extdata", "toy_copynumber.RData",
  package = "sigminer", mustWork = TRUE
))
cn_prepare <- prepare_copynumber(cn)
}
}
\seealso{
Other signature analysis prepare function series: \code{\link{prepare_maf}}
}
\author{
Shixiang Wang
}
\concept{signature analysis prepare function series}
