% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_series.R
\name{read_variation}
\alias{read_variation}
\title{Read genomic variation profile}
\usage{
read_variation(copynumber, maf, clinical_data = NULL)
}
\arguments{
\item{copynumber}{a \link{CopyNumber} object}

\item{maf}{a \link{MAF} object}

\item{clinical_data}{clinical.data data associated with each sample in copy number profile
and MAF.}
}
\value{
a \link{GenomicVariation} object
}
\description{
Read \link{CopyNumber} and \link{MAF} object as a new S4 object \link{GenomicVariation}
for uniform variation analysis. \strong{The function is initialized to construct structure of sigminer, please dont use it for now}.
}
\examples{
\donttest{
# Read MAF
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read_maf(maf = laml.maf)
# Load copy number object
load(system.file("extdata", "toy_copynumber.RData",
  package = "sigminer", mustWork = TRUE
))
# Combine as GenomicVariation object
gv <- read_variation(cn, laml)
}
}
\seealso{
Other read genomic variation data function series: \code{\link{read_copynumber}},
  \code{\link{read_maf}}
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
\concept{read genomic variation data function series}
