% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_sig_consensusmap.R
\name{show_sig_consensusmap}
\alias{show_sig_consensusmap}
\title{Show Signature Consensus Map}
\usage{
show_sig_consensusmap(
  sig,
  main = "Consensus matrix",
  tracks = c("consensus:", "silhouette:"),
  lab_row = NA,
  lab_col = NA,
  ...
)
}
\arguments{
\item{sig}{a \code{Signature} object obtained from \link{sig_extract}.}

\item{main}{Main title as a character string or a grob.}

\item{tracks}{Special additional annotation tracks to
  highlight associations between basis components and
  sample clusters: \describe{ \item{basis}{matches each row
  (resp. column) to the most contributing basis component
  in \code{basismap} (resp. \code{coefmap}). In
  \code{basismap} (resp. \code{coefmap}), adding a track
  \code{':basis'} to \code{annCol} (resp. \code{annRow})
  makes the column (resp. row) corresponding to the
  component being also highlited using the mathcing
  colours.} }}

\item{lab_row}{labels for the rows.}

\item{lab_col}{labels for the columns.}

\item{...}{other parameters passing to \code{NMF::consensusmap()}.}
}
\value{
nothing
}
\description{
This function is a wrapper of \code{NMF::consensusmap()}.
}
