% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_group_comparison.R
\name{get_group_comparison}
\alias{get_group_comparison}
\title{Get Comparison Result between Signature Groups}
\usage{
get_group_comparison(
  data,
  col_group,
  cols_to_compare,
  type = "ca",
  NAs = NA,
  verbose = FALSE
)
}
\arguments{
\item{data}{a \code{data.frame} containing signature groups and genotypes/phenotypes
(including categorical and continuous type data) want to analyze. User need to
construct this \code{data.frame} by him/herself.}

\item{col_group}{column name of signature groups.}

\item{cols_to_compare}{column names of genotypes/phenotypes want to summarize based on groups.}

\item{type}{a characater vector with length same as \code{cols_to_compare},
'ca' for categorical type and 'co' for continuous type.}

\item{NAs}{default is \code{NA}, filter \code{NA}s for categorical columns.
Otherwise a value (either length 1 or length same as \code{cols_to_compare}) fill \code{NA}s.}

\item{verbose}{if \code{TRUE}, print extra information.}
}
\value{
a \code{list} contains data, summary, p value etc..
}
\description{
Compare genotypes/phenotypes based on signature groups (samples are assigned to
several groups). For categorical
type, calculate fisher p value (using \link[stats:fisher.test]{stats::fisher.test}) and count table.
In larger than 2 by 2 tables, compute p-values by Monte Carlo simulation.
For continuous type, calculate anova p value (using \link[stats:aov]{stats::aov}),
summary table and Tukey Honest significant difference (using \link[stats:TukeyHSD]{stats::TukeyHSD}).
The result of this function can be plotted by \code{\link[=show_group_comparison]{show_group_comparison()}}.
}
\examples{
\donttest{
load(system.file("extdata", "toy_copynumber_signature_by_W.RData",
  package = "sigminer", mustWork = TRUE
))

# Assign samples to clusters
groups <- get_groups(sig, method = "k-means")

set.seed(1234)

groups$prob <- rnorm(10)
groups$new_group <- sample(c("1", "2", "3", "4", NA), size = nrow(groups), replace = TRUE)

# Compare groups (filter NAs for categorical coloumns)
groups.cmp <- get_group_comparison(groups[, -1],
  col_group = "group",
  cols_to_compare = c("prob", "new_group"),
  type = c("co", "ca"), verbose = TRUE
)

# Compare groups (Set NAs of categorical columns to 'Rest')
groups.cmp2 <- get_group_comparison(groups[, -1],
  col_group = "group",
  cols_to_compare = c("prob", "new_group"),
  type = c("co", "ca"), NAs = "Rest", verbose = TRUE
)
}
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
