% Generated by roxygen2 (4.0.2): do not edit by hand
\name{duration_viterbi}
\alias{duration_viterbi}
\title{Compute most probable path with extended Viterbi algorithm}
\usage{
duration_viterbi(aa_sample, pipar, tpmpar, od, params)
}
\arguments{
\item{aa_sample}{\code{character} vector representing single aminoacid sequence.}

\item{pipar}{Probabilities of initial state in Markov Model.}

\item{tpmpar}{Matrix with transition probabilities between states.}

\item{od}{Matrix of response probabilities. Eg. od[1,2] is a
probability of signal 2 in state 1.}

\item{params}{Matrix of probability distribution for duration.
Eg. params[10,2] is probability of duration of time 10 in state 2.}
}
\value{
A list of length four:
\itemize{
\item{path}{ a vector of most probable path}
\item{viterbi}{ values of probability in all intermediate points,}
\item{psi}{ matrix that gives for every signal and state the previous state in
viterbi path,}
\item{duration}{ matrix that gives for every signal and state gives the duration
in that state on viterbi path.}
}
}
\description{
Viterbi algorithm for Hidden Markov Model with duration
Valid only for special case on data
}
\note{
Currently has very restricted application to specific input All computations are on logarithms of probabilities
}

