% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUCTest.R
\name{resampleTestAUC}
\alias{resampleTestAUC}
\title{Wrap AUC resampling test results.}
\usage{
resampleTestAUC(
  d,
  modelName,
  yName,
  yTarget = TRUE,
  ...,
  na.rm = FALSE,
  returnScores = FALSE,
  nrep = 100,
  parallelCluster = NULL
)
}
\arguments{
\item{d}{data.frame}

\item{modelName}{character model column name}

\item{yName}{character outcome column name}

\item{yTarget}{target to match to y}

\item{...}{extra arguments (not used)}

\item{na.rm}{logical, if TRUE remove NA values}

\item{returnScores}{logical if TRUE return detailed resampledScores.}

\item{nrep}{number of permutation repetitions to estimate p values.}

\item{parallelCluster}{(optional) a cluster object created by package parallel or package snow.}
}
\value{
AUC statistic
}
\description{
Estimate significance of AUC by resampling test.
}
\examples{

set.seed(25325)
d <- data.frame(x1=c(1,2,3,4,5,6,7,7),
                y=c(FALSE,TRUE,FALSE,FALSE,
                    TRUE,TRUE,FALSE,TRUE))
resampleTestAUC(d,'x1','y',TRUE)


}
