% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{silv_dominant_height}
\alias{silv_dominant_height}
\title{Calculates the dominant height}
\usage{
silv_dominant_height(diameter, height, ntrees = NULL, which = "assman")
}
\arguments{
\item{diameter}{Numeric vector with diameter classes}

\item{height}{Numeric vector with averaged heights by diameter class}

\item{ntrees}{Optional. Numeric vector with number of trees per hectare.
Use this argument when you have aggregated data by diametric classes (see details).}

\item{which}{The method to calculate the dominant height (see details)}
}
\value{
A numeric vector
}
\description{
Calculates the dominant height using the Assman equation or the Hart equation
}
\details{
The dominant height \eqn{H_0} is the mean height of dominant trees, which is
less affected than overall mean height by thinning or other treatments.
\itemize{
\item \bold{Assman}: calculates the \eqn{H_0} as the mean height of the 100 thickest
trees per hectare
\item \bold{Hart}: calculates the \eqn{H_0} as the mean height of the 100 tallest
trees per hectare
}

When \code{ntrees = NULL}, the function will assume that each diameter and height
belongs to only one trees. If you have data aggregated by hectare, you'll use the
number of trees per hectare in this argument.
}
\examples{
## calculate h0 for inventory data grouped by plot_id and species
library(dplyr)
inventory_samples |>
mutate(dclass = silv_diametric_class(diameter)) |>
  summarise(
    height = mean(height, na.rm = TRUE),
    ntrees = n(),
    .by    = c(plot_id, species, dclass)
  ) |>
  mutate(
    ntrees_ha = silv_ntrees_ha(ntrees, plot_size = 10),
    h0        = silv_dominant_height(dclass, height, ntrees_ha),
    .by       = c(plot_id, species)
  )
}
\references{
Assmann, E. (1970) The principles of forest yield study: Studies in the
organic production, structure, increment, and yield of forest stands. Pergamon Press, Oxford.
}
