% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_Shuttleworth_Wallace.R
\name{Model_SW}
\alias{Model_SW}
\title{Simulation of evapotranspiration using Shuttleworth-Wallace model}
\usage{
Model_SW(data, param)
}
\arguments{
\item{data}{A data box. Contains the daily data required by the model.
You can refer to the function create_modelData()}

\item{param}{A list. Contains additional parameters.}
}
\value{
A list for the model result including a data frame of daily model result
       ,a list of plots, A data frame of summary data
}
\description{
Simulation of evapotranspiration using Shuttleworth-Wallace model
}
\note{
The stages of data should include all four stages.
 If a crop has multiple growth cycles, each cycle should include all four stages.
}
\examples{
   library(simET)
   #--Data preparation
   data("FIalfalfa")
   #--Parameter preparation
   param_SW<-list(
       plant=list(
                 #the canopy extinction coefficient for net radiation
                 kRn=0.3,
                 alpha_plant=0.3,#Canopy reflectance
                 w=0.01,#Leaf width
                 Lmax=10,#Maximum leaf area index
                 a1=10,# Leaf stomatal resistance coefficients
                 a2=0.005,# Leaf stomatal resistance coefficients
                 p=0.5,#the param of reduction factor for T
                 rootDepth=1.2 #Maximum root depth
                 ),
       Soil=list(
               zs0=0.04,#The soil surface roughnesslength (m)
               tau2=2,#Soil tortuosity
               PHI_p=2,	 #Soil porosity
               #The soil pore-size distribution index
               #from the Brooks-Corey equation.
               lambda_p=0.18,
               l1=0.02,#Depth of the surface soil layer (m)
               l2=1.2,#Depth of the root layer (m)
               #Saturation water content of evaporation layer
               THETA_v_sat_1=0.36,
               THETA_v_sat_2=0.40, #Saturation water content of root layer
               THETA_start_1=0.2,#Initial water content of evaporation layer
               THETA_start_2=0.36,#Initial water content of root layer
               THETA_wp1=0.15,#Wilting point of evaporation layer
               THETA_wp2=0.15,#Wilting point of root layer
               #Empirical coefficient of evaporation layer.
               #13 for homogenous soil
               alpha1=14,
               alpha2=14,#Empirical coefficient of root layer.
               #Saturated hydraulic conductitity of evaporation layer
               Ksat_1=13.52,
               Ksat_2=0.02,#Saturated hydraulic conductitity of root layer
               #Capillary rise model parameters
               CR_param=c(430,-0.32,313,-0.16,-1.4,6.8,0.5,-0.98)
               ),
     Mete=list(
              nu=2,#The wind speed extinction coefficient
              nK=2, #The eddy diffusivity extinction coefficient(taken as 2)
              zr=2,	 #The reference height (m)
              ##The vapor diffusion coefficient in air (24.7 10-6 m2 s-1)
              Dm_v=24.7*10^(-6),
              deltaT=1 #Time step difference (day)
              )
         )
   #--Run model
   Re_SW<-Model_SW(data = FIalfalfa, param = param_SW)
   #--The Result data
   Re_SW$Result
   Re_SW$Plot
   #--The goodness Of Fit
   estimate_goodnessOfFit(Sim = Re_SW$Result$Sim_SoilWater,
                         Obs = Re_SW$Result$SoilWater)
}
