\name{vbinom}
\alias{vbinom}
\alias{Binomial}

\title{Variate Generator for the Binomial Distribution}
\description{
  Generates random variates from the binomial distribution, with options for
  independent streams and antithetic variates.
}
\usage{
  vbinom(n, size, prob, stream = NULL, antithetic = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{n}{number of observations}
  \item{size}{integer number of trials (zero or more)}
  \item{prob}{probability of success on each trial}
  \item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
    to generate uniform variates to invert via \code{\link[=qbinom]{stats::qbinom}}; 
    otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
    from which to generate uniform variates to invert via
    \code{\link[=qbinom]{stats::qbinom}}}
  \item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
    variate(s) generated via either \code{\link[=runif]{stats::runif}} or
    \code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
    \eqn{1 - u}}
}
\details{
  Generates random variates from the binomial distribution.

  Binomial variates are generated by inverting uniform(0,1) variates
  produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
  \code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}} (if
  \code{stream} is not \code{NULL}).
  In either case, \code{\link[=qbinom]{stats::qbinom}} is used to invert the
  uniform(0,1) variate(s).
  In this way, using \code{vbinom} provides a monotone and synchronized
  binomial variate generator, although not particularly fast.

  The stream indicated must be an integer between 1 and 25 inclusive.

  The binomial distribution with parameters \code{size} = \eqn{n} and
  \code{prob} = \eqn{p} has pmf

           \deqn{p(x) = {n \choose x} p^x (1-p)^{(n-x)}}{%
                 p(x) = choose(n, x) p^x (1-p)^(n-x)}

  for \eqn{x = 0, \ldots, n}.
}
\value{
  A vector of binomial random variates.
}
\seealso{
    \code{\link[=rbinom]{stats::rbinom}}, \code{\link[=runif]{stats::runif}},
    \code{\link{rstream}}, \code{\link{set.seed}}
}
\author{Barry Lawson (\email{blawson@richmond.edu}), 
        Larry Leemis (\email{leemis@math.wm.edu})}
\examples{
set.seed(8675309)
vbinom(3, size = 10, prob = 0.3)  # inverts stats::runif using stats::qbinom

set.seed(8675309)
vbinom(3, 10, 0.3, stream = 1) # inverts rstream::rstream.sample using stats::qbinom
vbinom(3, 10, 0.3, stream = 2)

set.seed(8675309)
vbinom(1, 10, 0.3, stream = 1) # inverts rstream::rstream.sample using stats::qbinom
vbinom(1, 10, 0.3, stream = 2)
vbinom(1, 10, 0.3, stream = 1)
vbinom(1, 10, 0.3, stream = 2)
vbinom(1, 10, 0.3, stream = 1)
vbinom(1, 10, 0.3, stream = 2)

set.seed(8675309)
variates <- vbinom(1000, size = 10, prob = 0.3, stream = 1)
set.seed(8675309)
variates <- vbinom(1000, size = 10, prob = 0.3, stream = 1, antithetic = TRUE)
}
\keyword{distribution}  % RShowDoc("KEYWORDS") for suggested list
\concept{random variate generation}
