% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_simulation_results.R
\name{aggregate_simulation_results}
\alias{aggregate_simulation_results}
\title{Test a passed test statistic on the simulated data}
\usage{
aggregate_simulation_results(
  orig.data,
  predictions,
  outcomename,
  summarizer = calculate_average_outcome,
  ...
)
}
\arguments{
\item{orig.data}{The raw data (dataframe)}

\item{predictions}{The results from process_outcome_model.}

\item{outcomename}{Outcome to use.}

\item{summarizer}{A function to calculate some summary quantity, Default:
calculate_average_outcome}

\item{...}{Extra arguments passed to the summarizer function.}
}
\value{
List of length two, with first item being the observed value of the
  test statistic and the second being a numeric vector representing the
  emperical reference distribution.
}
\description{
This method is used to look at summary statistics such as
  average impact post-policy, and see how the predictive distribution
  compares to the observed.
}
\examples{
predictions = process_outcome_model( "pbail", mecklenberg,
                                    t0=0, R = 5,
                                    summarize = FALSE, smooth=FALSE )
sstat = aggregate_simulation_results( orig.data = mecklenberg, outcomename = "pbail",
                                     predictions = predictions, months = 1:18 )
sstat$t
sstat$t.obs

}
