% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibSample.R
\docType{methods}
\name{calibSample}
\alias{calibSample}
\alias{calibSample,df_or_dataObj_or_simPopObj,dataFrame_or_Table-method}
\title{Calibrate sample weights}
\description{
Calibrate sample weights according to known marginal population totals.
Based on initial sample weights, the so-called \emph{g}-weights are computed
by generalized raking procedures.
}
\details{
The methods return a list containing both the \emph{g}-weights (slot
\code{g_weights}) as well as the final weights (slot \code{final_weights})
(initial sampling weights adjusted by the \emph{g}-weights.
}
\note{
This is a faster implementation of parts of
\code{\link[sampling]{calib}} from package \code{sampling}. Note that the
default calibration method is raking and that the truncated linear method is
not yet implemented.
}
\section{Methods}{
 \describe{The function provides methods with the following
signatures.  \item{list("signature(inp=\"df_or_dataObj_or_simPopObj\",
totals=\"dataFrame_or_Table\",...)")}{ Argument 'inp' must be an object of
class \code{data.frame}, \code{\linkS4class{dataObj}} or
\code{\linkS4class{simPopObj}} and the totals must be specified in either
objects of class \code{table} or \code{data.frame}. If argument 'totals' is
a data.frame it must be provided in a way that in the first columns
n-columns the combinations of variables are listed. In the last column, the
frequency counts must be specified. Furthermore, variable names of all but
the last column must be available also from the sample data specified in
argument 'inp'. If argument 'total' is a table (e.g. created with function
\code{\link{tableWt}}, it must be made sure that the dimnames match the
variable names (and levels) of the specified input data set.  } }
}
\examples{
data(eusilcS)
eusilcS$agecut <- cut(eusilcS$age, 7)
inp <- specifyInput(data=eusilcS, hhid="db030", hhsize="hsize", strata="db040", weight="db090")

## for simplicity, we are using population data directly from the sample, but you get the idea
totals1 <- tableWt(eusilcS[, c("agecut","rb090")], weights=eusilcS$rb050)
totals2 <- tableWt(eusilcS[, c("rb090","agecut")], weights=eusilcS$rb050)
totals3 <- tableWt(eusilcS[, c("rb090","agecut","db040")], weights=eusilcS$rb050)
totals4 <- tableWt(eusilcS[, c("agecut","db040","rb090")], weights=eusilcS$rb050)

weights1 <- calibSample(inp, totals1)
totals1.df <- as.data.frame(totals1)
weights1.df <- calibSample(inp, totals1.df)
identical(weights1, weights1.df)

# we can also use a data.frame and an optional weight vector as input
df <- as.data.frame(inp@data)
w <- inp@data[[inp@weight]]
weights1.x <- calibSample(df, totals1.df, w=inp@data[[inp@weight]])
identical(weights1, weights1.x)

weights2 <- calibSample(inp, totals2)
totals2.df <- as.data.frame(totals2)
weights2.df <- calibSample(inp, totals2.df)
identical(weights2, weights2.df)

\dontrun{
## approx 10 seconds computation time ...
weights3 <- calibSample(inp, totals3)
totals3.df <- as.data.frame(totals3)
weights3.df <- calibSample(inp, totals3.df)
identical(weights3, weights3.df)

## approx 10 seconds computation time ...
weights4 <- calibSample(inp, totals4)
totals4.df <- as.data.frame(totals4)
weights4.df <- calibSample(inp, totals4.df)
identical(weights4, weights4.df)
}
}
\author{
Andreas Alfons and Bernhard Meindl
}
\references{
Deville, J.-C. and Saerndal, C.-E. (1992)
Calibration estimators in survey sampling. \emph{Journal of the American
Statistical Association}, \bold{87}(418), 376--382.  Deville, J.-C.,
Saerndal, C.-E. and Sautory, O. (1993) Generalized raking
procedures in survey sampling. \emph{Journal of the American Statistical
Association}, \bold{88}(423), 1013--1020.
}
\keyword{methods}
\keyword{survey}

