% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{TestPhiHurwitz}
\alias{TestPhiHurwitz}
\title{Test Hurwitz Stability of a Drift Matrix}
\usage{
TestPhiHurwitz(phi, eps = 0)
}
\arguments{
\item{phi}{Numeric matrix.
The drift matrix (\eqn{\boldsymbol{\Phi}}).}

\item{eps}{Nonnegative numeric tolerance (default \code{0.0}).
The test checks \eqn{\Re(\lambda_i) < -\text{eps}} for all eigenvalues.}
}
\description{
Returns \code{TRUE} iff the drift matrix \eqn{\boldsymbol{\Phi}}
is Hurwitz-stable,
i.e., all eigenvalues have real parts strictly less than \code{-eps}.
Setting \code{eps = 0} enforces the usual strict condition
\eqn{\max \Re\{\lambda_i(\boldsymbol{\Phi})\} < 0}.
A small positive \code{eps} (e.g., \code{1e-12}) can be used
to guard against floating-point round-off.
}
\examples{
# Unstable example (spectral abscissa >= 0):
phi <- matrix(
  data = c(
    0.10, -0.40,
    0.50, 0.20
  ),
  nrow = 2
)
TestPhiHurwitz(phi = phi) # FALSE

# Stable example (all real parts < 0):
phi <- matrix(
  data = c(
    -0.50, -0.20,
     1.00, -0.30
  ),
  nrow = 2
)
TestPhiHurwitz(phi = phi) # TRUE
TestPhiHurwitz(phi = phi, eps = 1e-12) # also TRUE with tolerance

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{linsde}
\keyword{simStateSpace}
\keyword{test}
