% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{with_progress_cnd}
\alias{with_progress_cnd}
\title{Conditional \code{\link[progressr]{with_progress}}.}
\usage{
with_progress_cnd(ex, progress = TRUE)
}
\arguments{
\item{ex}{expression}

\item{progress}{logical, Default: TRUE}
}
\value{
No return value, called for side effects
}
\description{
Internal function. Use instead of
\code{\link[progressr]{with_progress}} within custom functions with progress
bars.
}
\details{
This wrapper adds a progress parameter to \code{\link[progressr]{with_progress}}
so that we can control the progress bar in the user facing functions. The progressbar
only shows in interactive mode.
}
\examples{
if (interactive()) {

 with_progress_cnd(
   purrr_bar(rep(0.25, 5), .purrr = purrr::map, .f = Sys.sleep, .steps = 5),
   progress = TRUE
 )

 with_progress_cnd(
   purrr_bar(rep(0.25, 5), .purrr = purrr::map, .f = Sys.sleep, .steps = 5),
   progress = FALSE
 )

# wrap a function with progress bar with another call with progress bar

f1 <- function(x, progress = TRUE) {
  with_progress_cnd(
    purrr_bar(x, .purrr = purrr::walk, .f = Sys.sleep, .steps = length(x), .progress = progress),
    progress = progress
  )
}

# inner progress bar blocks outer progress bar
progressr::with_progress(
  purrr_bar(
    rep(rep(1, 3),3), .purrr = purrr::walk, .f = f1, .steps = 3,
    .f_args = list(progress = TRUE)
  )
)

# inner progress bar turned off
progressr::with_progress(
  purrr_bar(
    rep(list(rep(0.25, 3)), 5), .purrr = purrr::walk, .f = f1, .steps = 5,
    .f_args = list(progress = FALSE)
  )
)
}
}
\seealso{
\code{\link[progressr]{with_progress}}
}
