% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep.R
\name{get_pat_pool_config}
\alias{get_pat_pool_config}
\title{Configure study patient pool by site parameters.}
\usage{
get_pat_pool_config(df_visit, df_site, min_n_pat_with_med75 = 1)
}
\arguments{
\item{df_visit}{dataframe}

\item{df_site}{dataframe as created by site_aggr()}

\item{min_n_pat_with_med75}{minimum number of patients with visit_med_75 for
simulation, Default: 1}
}
\value{
dataframe
}
\description{
Internal Function used by \code{\link[=sim_sites]{sim_sites()}}
}
\details{
For simulating a study we need to configure the study patient
pool to match the configuration of the sites
}
\examples{
df_visit1 <- sim_test_data_study(n_pat = 100, n_sites = 5,
                                      frac_site_with_ur = 0.4, ur_rate = 0.6)

df_visit1$study_id <- "A"

df_visit2 <- sim_test_data_study(n_pat = 1000, n_sites = 3,
                                      frac_site_with_ur = 0.2, ur_rate = 0.1)

df_visit2$study_id <- "B"

df_visit <- dplyr::bind_rows(df_visit1, df_visit2)

df_site <- site_aggr(df_visit)

df_config <- get_pat_pool_config(df_visit, df_site)

df_config
}
