% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/action_node_indexing.R
\name{N}
\alias{N}
\title{Subsetting/Indexing \code{DAG} Nodes}
\usage{
N(DAG)
}
\arguments{
\item{DAG}{A DAG object that was defined using functions \code{\link{node}} and \code{\link{set.DAG}}.}
}
\value{
returns a list of nodes that can be indexed as a typical named list "[[]]".
}
\description{
Subsetting/Indexing \code{DAG} Nodes
}
\examples{
D <- DAG.empty()
D <- D + node(name="W1", distr="rbern", prob=plogis(-0.5))
D <- D + node(name="W2", distr="rbern", prob=plogis(-0.5 + 0.5*W1))
D <- set.DAG(D)
#Returns all nodes from DAG D
N(D)
#Returns node W1 from DAG D
N(D)["W1"]
}

