% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{NetInd.to.sparseAdjMat}
\alias{NetInd.to.sparseAdjMat}
\title{Convert Network IDs Matrix into Sparse Adjacency Matrix}
\usage{
NetInd.to.sparseAdjMat(NetInd_k, nF)
}
\arguments{
\item{NetInd_k}{Matrix of network IDs of dimension \code{(n=nrow(sparseAdjMat),Kmax)},
where each row \code{i} consists of the network IDs (row number of friends) of observation \code{i}. Remainders are filled with \code{NA}s.}

\item{nF}{Integer vector of length \code{n} specifying the number of friends for each observation.}
}
\value{
Network represented as a sparse adjacency matrix (S4 class object \code{dgCMatrix} from package \code{Matrix}).
NOTE: The friend IDs for observation \code{i} will be listed in column \code{i}
(i.e, \code{which(sparseAdjMat[,i])} are friends of \code{i}).
}
\description{
Convert \code{simcausal} network ID matrix (\code{NetInd_k}) into a network represented by a sparse adjacency matrix.
}
\seealso{
\code{\link{network}}; \code{\link{sparseAdjMat.to.igraph}}; \code{\link{igraph.to.sparseAdjMat}}; \code{\link{sparseAdjMat.to.NetInd}};
}

