% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simcausal.r
\name{plotDAG}
\alias{plotDAG}
\title{Plot DAG}
\usage{
plotDAG(DAG, tmax = NULL, xjitter, yjitter, node.action.color,
  vertex_attrs = list(), edge_attrs = list(), excludeattrs,
  customvlabs, verbose = getOption("simcausal.verbose"))
}
\arguments{
\item{DAG}{A DAG object that was specified by calling \code{\link{set.DAG}}}

\item{tmax}{Maximum time-point to plot for time-varying DAG objects}

\item{xjitter}{Amount of random jitter for node x-axis plotting coordinates}

\item{yjitter}{Amount of random jitter for node y-axis plotting coordinates}

\item{node.action.color}{Color of the action node labels (only for action DAG of class DAG.action). If missing, defaults to red.}

\item{vertex_attrs}{A named list of \code{igraph} graphical parameters for plotting DAG vertices. These parameters are passed on to \code{add.vertices} \code{igraph} function.}

\item{edge_attrs}{A named list of \code{igraph} graphical parameters for plotting DAG edges. These parameters are passed on to \code{add.edges} \code{igraph} function.}

\item{excludeattrs}{A character vector for DAG nodes that should be excluded from the plot}

\item{customvlabs}{A named vector of custom DAG node labels (replaces node names from the DAG object).}

\item{verbose}{Set to \code{TRUE} to print messages on status and information to the console.
Turn this off by default using options(simcausal.verbose=FALSE).}
}
\description{
Plot DAG object using functions from \code{igraph} package.
The default setting is to keep the regular (observed) DAG nodes with \code{shape} set to "none", which can be over-ridden by the user.
For latent (hidden) DAG nodes the default is to:
1) set the node color as grey;
2) enclose the node by a circle; and
3) all directed edges coming out of the latent node are plotted as dashed.
}
\references{
Sofrygin O, van der Laan MJ, Neugebauer R (2017).
"simcausal R Package: Conducting Transparent and Reproducible Simulation Studies of Causal Effect Estimation with Complex Longitudinal Data."
Journal of Statistical Software, 81(2), 1-47. doi: 10.18637/jss.v081.i02.
}
