% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{sparseAdjMat.to.igraph}
\alias{sparseAdjMat.to.igraph}
\title{Convert Network from Sparse Adjacency Matrix into igraph Object}
\usage{
sparseAdjMat.to.igraph(sparseAdjMat, mode = "directed")
}
\arguments{
\item{sparseAdjMat}{Network represented as a sparse adjacency matrix (S4 class object \code{dgCMatrix} from package \code{Matrix}).
NOTE: for directed graphs the friend IDs pointing into vertex \code{i} are assumed to be listed in the column \code{i}
(i.e, \code{which(sparseAdjMat[,i])} are friends of \code{i}).}

\item{mode}{Character scalar, passed on to \code{igraph::graph_from_adjacency_matrix}, specifies how igraph should interpret the supplied matrix.
See \code{?igraph::graph_from_adjacency_matrix} for details.}
}
\value{
A list containing the network object(s) of type \code{DAG.net}.
}
\description{
Uses \code{graph_from_adjacency_matrix} function from the \code{igraph} package to convert the network in sparse adjacency matrix format into \code{igraph} network object.
}
\seealso{
\code{\link{network}}; \code{\link{igraph.to.sparseAdjMat}}; \code{\link{sparseAdjMat.to.NetInd}}; \code{\link{NetInd.to.sparseAdjMat}};
}
