# get_geno
#
#' Get genotype at a single position
#'
#' With data on the continuous crossover location information produced by
#' sim_from_pedigree, grab the genotype at a given position.
#'
#' @param xodat The sort of detailed genotype/XO data generated by
#' [sim_from_pedigree()]
#' @param position Position (in cM) for which to obtain genotypes
#'
#' @return A numeric matrix with two columns: the maternal and
#' paternal allele for each individual.
#'
#' @export
#' @keywords utilities
#' @seealso [sim_from_pedigree()], [convert2geno()]
#'
#' @examples
#' # simulate AIL pedigree
#' tab <- sim_ail_pedigree(12, 30)
#' # simulate data from that pedigree
#' dat <- sim_from_pedigree(tab)
#' # get genotype at position 30 cM
#' geno <- get_geno(dat, 30)
get_geno <-
    function(xodat, position)
{
    L <- max(xodat[[1]]$mat$locations)

    if(position < 0 || position > L)
        stop("position is outside the range of the data")
    if(position == 0) position <- -1

    tol <- 1e-8
    if(position > L - tol)
        position <- L - tol

    output <- .get_geno(xodat, position)
    dimnames(output) <- list(names(xodat), c("mat", "pat"))

    output
}
