% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdesign.R
\name{simdesign_discunif}
\alias{simdesign_discunif}
\title{Uniform disc sampling design specification}
\usage{
simdesign_discunif(
  r_min = 0,
  r_max = 1,
  angle_min = 0,
  angle_max = 2 * pi,
  name = "Uniform circle simulation design",
  ...
)
}
\arguments{
\item{r_min}{Minimum radius of points.}

\item{r_max}{Maximum radius of points.}

\item{angle_min}{Minimum angle of points (between 0 and 2pi).}

\item{angle_max}{Maximum angle of points (between 0 and 2pi).}

\item{name}{Character, optional name of the simulation design.}

\item{...}{Further arguments are passed to the \code{\link{simdesign}} constructor.}
}
\value{
List object with class attribute "simdesign_discunif" (S3 class), inheriting
from "simdesign". It contains the same entries as a \code{\link{simdesign}}
object but in addition the following entries:

\describe{
\item{\code{r_min}}{}
\item{\code{r_max}}{}
\item{\code{angle_min}}{}
\item{\code{angle_max}}{}
}
}
\description{
Provides 2-dimensional points, spread uniformly over disc, or partial
disc segment (i.e. a circle, or ring, or ring segment). Useful for e.g.
building up clustering exercises.
}
\details{
The distribution of points on a disk depends on the radius - the farther out,
the more area the points need to cover. Thus, simply sampling two uniform
values for radius and angle will not work. See references.
}
\examples{
disc_sampler <- simdesign_discunif()
plot(simulate_data(disc_sampler, 1000, seed = 19))

ring_segment_sampler <- simdesign_discunif(r_min = 0.5, angle_min = 0.5 * pi)
plot(simulate_data(ring_segment_sampler, 1000, seed = 19))

circle_sampler <- simdesign_discunif(r_min = 1)
plot(simulate_data(circle_sampler, 1000, seed = 19))

}
\references{
\url{https://mathworld.wolfram.com/DiskPointPicking.html}
}
