% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_simulation.R
\name{new_var_set}
\alias{new_var_set}
\alias{add_var}
\alias{nvar}
\alias{npar}
\title{Create and modify variable sets for batch simulation}
\usage{
new_var_set()

add_var(var_set, par_name, var_name, start, end, by)

nvar(var_set)

npar(var_set)
}
\arguments{
\item{var_set}{A \code{var_set} object.}

\item{par_name, var_name}{The name of the parameter and variable
in the simulation function}

\item{start, end, by}{The data points where you want to test the variables.
Passed to \code{seq}.}
}
\description{
A variable set contains the descriptions of the relevant variables in a
batch simulation. Use \code{new_var_set} to create an S3 \code{var_set}
object, and use \code{add_var} to add descriptions of variables.
}
\section{Functions}{
\itemize{
\item \code{new_var_set}: Create a \code{var_set}.

\item \code{add_var}: Add a variable to the \code{var_set}.

\item \code{nvar}: The number of variables.

\item \code{npar}: The number of parameters.
}}

\examples{
test <- new_var_set()
test <- test \%>\%
  add_var("par1", "var1", 1, 2, 0.1) \%>\%
  add_var("par2", "var2", 1, 2, 0.1)
}
\seealso{
\code{\link{make_var_grid}} for making grids from variable sets;
\code{\link{batch_simulation}} for running batch simulation and a
concrete example.
}
