% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience_funcs.R
\name{to}
\alias{to}
\title{Generate arrivals stopping at a specified time}
\usage{
to(stop_time, dist)
}
\arguments{
\item{stop_time}{the time at which to stop the generator.}

\item{dist}{a function modelling the interarrival times.}
}
\value{
Returns a generator function.
}
\description{
Generator convenience function to generate inter-arrivals with a specified stop time.
}
\examples{
t0 <- create_trajectory() \%>\% timeout(0)
env <- simmer(verbose=TRUE) \%>\%
  add_generator("dummy", t0, to(5, function() runif(1, 1, 2))) \%>\%
  run(10)
}
\seealso{
\link{add_generator}, \link{at}, \link{every}, \link{from}, 
\link{from_to}.
}

