% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schedule-methods.R
\name{schedule}
\alias{schedule}
\title{Generate a Scheduling Object}
\usage{
schedule(timetable, values, period = Inf)
}
\arguments{
\item{timetable}{absolute points in time in which the desired value changes.}

\item{values}{one value for each point in time.}

\item{period}{period of repetition.}
}
\value{
Returns a \code{schedule} object.
}
\description{
Resource convenience function to generate a scheduling object from a timetable specification.
}
\examples{
# Schedule 3 units from 8 to 16 h
#          2 units from 16 to 24 h
#          1 units from 24 to 8 h
capacity_schedule <- schedule(c(8, 16, 24), c(3, 2, 1), period=24)

env <- simmer() \%>\%
  add_resource("dummy", capacity_schedule)
}
\seealso{
\code{\link{add_resource}}.
}
