% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{UCI.transfusion}
\alias{UCI.transfusion}
\title{Blood Transfusion Service Center Data Set}
\format{A data frame with 748 rows and 5 variables}
\source{
Dataset downloaded from the UCI Machine Learning Repository.
\url{http://archive.ics.uci.edu/ml/datasets/Blood+Transfusion+Service+Center}

Original Owner and Donor:
Prof. I-Cheng Yeh
Department of Information Management
Chung-Hua University
Hsin Chu, Taiwan 30067, R.O.C.
e-mail: icyeh 'at' chu.edu.tw
}
\usage{
data(UCI.transfusion)
}
\description{
Data taken from the Blood Transfusion Service Center in Hsin-Chu City in Taiwan.
To demonstrate the RFMTC marketing model (a modified version of RFM), this study adopted the donor database
of Blood Transfusion Service Center in Hsin-Chu City in Taiwan.
The center passes their blood transfusion service bus to one university in Hsin-Chu City to gather blood
donated about every three months.
To build a FRMTC model, we selected 748 donors at random from the donor database.
These 748 donor data, each one included R (Recency - months since last donation),
F (Frequency - total number of donation), M (Monetary - total blood donated in c.c.),
T (Time - months since first donation), and a binary variable representing whether he/she donated blood in March 2007
(1 stand for donating blood; 0 stands for not donating blood).
}
\details{
The variables are as follows:

\itemize{
\item R. Recency - months since last donation
\item F. Frequency - total number of donations
\item M. Monetary - total blood donated in c.c. (mL)
\item T. Time - months since first donation
\item y. a binary variable representing whether he/she donated blood in March 2007 (1=yes; 0 =no)
}
}
\references{
Yeh, I-Cheng, Yang, King-Jang, and Ting, Tao-Ming, "Knowledge discovery on RFM model using Bernoulli sequence",
Expert Systems with Applications, 2008. DOI: 10.1016/j.eswa.2008.07.018

Lichman, M. (2013). UCI Machine Learning Repository [\url{http://archive.ics.uci.edu/ml}].
Irvine, CA: University of California, School of Information and Computer Science.
}
\keyword{datasets}

