% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_line_fun.R
\name{ggplot_line_col}
\alias{ggplot_line_col}
\title{Line ggplot that is coloured.}
\usage{
ggplot_line_col(data, x_var, y_var, col_var, hover_var = NULL,
  x_scale_date_format = "\%Y", y_scale_zero = TRUE,
  y_scale_trans = "identity", col_scale_drop = FALSE, points = TRUE,
  point_size = 1, pal = NULL, rev_pal = FALSE, legend_ncol = 3,
  title = "[Title]", subtitle = NULL, x_title = "[X title]",
  y_title = "[Y title]", col_title = "", caption = "",
  legend_labels = NULL, font_family = "Helvetica",
  font_size_title = 11, font_size_body = 10, wrap_title = 70,
  wrap_subtitle = 80, wrap_x_title = 50, wrap_y_title = 50,
  wrap_col_title = 25, wrap_caption = 80, isMobile = FALSE)
}
\arguments{
\item{data}{A tibble or dataframe. Required input.}

\item{x_var}{Unquoted numeric or date variable to be on the x axis. Required input.}

\item{y_var}{Unquoted numeric variable to be on the y axis. Required input.}

\item{col_var}{Unquoted categorical variable for lines and points to be coloured by. Required input.}

\item{hover_var}{Unquoted variable to be an additional hover variable for when used inside plotly::ggplotly(). Defaults to NULL.}

\item{x_scale_date_format}{Date format for x axis labels.}

\item{y_scale_zero}{TRUE or FALSE whether the minimum of the y scale is zero. Defaults to TRUE.}

\item{y_scale_trans}{A string specifying a transformation for the y axis scale, such as "log10" or "sqrt". Defaults to "identity".}

\item{col_scale_drop}{TRUE or FALSE of whether to drop unused levels from the legend. Defaults to FALSE.}

\item{points}{TRUE or FALSE of whether to include points. Defaults to TRUE.}

\item{point_size}{Size of points. Defaults to 1. Only applicable to where points equals TRUE.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the Stats NZ palette.}

\item{rev_pal}{Reverses the palette. Defaults to FALSE.}

\item{legend_ncol}{The number of columns in the legend.}

\item{title}{Title string. Defaults to "[Title]".}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{x_title}{X axis title string. Defaults to "[X title]".}

\item{y_title}{Y axis title string. Defaults to "[Y title]".}

\item{col_title}{Colour title string for the legend. Defaults to NULL.}

\item{caption}{Caption title string. Defaults to NULL.}

\item{legend_labels}{A vector of manual legend label values. Defaults to NULL, which results in automatic labels.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{wrap_title}{Number of characters to wrap the title to. Defaults to 70. Not applicable where isMobile equals TRUE.}

\item{wrap_subtitle}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{wrap_x_title}{Number of characters to wrap the x title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_y_title}{Number of characters to wrap the y title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_col_title}{Number of characters to wrap the colour title to. Defaults to 25. Not applicable where isMobile equals TRUE.}

\item{wrap_caption}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. In a shinyapp, isMobile should be specified as input$isMobile.}
}
\value{
A ggplot object.
}
\description{
Line ggplot that is coloured, but not facetted.
}
\examples{
plot_data <- dplyr::storms \%>\%
  dplyr::mutate(status = stringr::str_to_sentence(status)) \%>\%
  dplyr::group_by(year, status) \%>\%
  dplyr::summarise(wind = round(mean(wind), 2))

plot <- ggplot_line_col(data = plot_data, x_var = year, y_var = wind, col_var = status)

plot

plotly::ggplotly(plot, tooltip = "text")
}
