% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly.R
\name{plotly_reverse_legend}
\alias{plotly_reverse_legend}
\title{Reverse plotly legend elements.}
\usage{
plotly_reverse_legend(plotly)
}
\arguments{
\item{plotly}{A plotly object.}
}
\description{
Reverse plotly legend elements.
}
\examples{
plot_data <- ggplot2::diamonds \%>\%
   dplyr::mutate(cut = stringr::str_to_sentence(cut)) \%>\%
   dplyr::group_by(cut, clarity) \%>\%
   dplyr::summarise(average_price = mean(price)) \%>\%
   dplyr::mutate(average_price_thousands = round(average_price / 1000, 1)) \%>\%
   dplyr::ungroup()
   
plot <- ggplot_hbar_col(data = plot_data, 
                       x_var = average_price_thousands, 
                       y_var = cut, 
                       col_var = clarity, 
                       legend_ncol = 4,
                       title = "Average diamond price by cut and clarity", 
                       x_title = "Average price ($US thousands)", 
                       y_title = "Cut")

plotly::ggplotly(plot, tooltip = "text")

plotly::ggplotly(plot, tooltip = "text") \%>\% 
   plotly_reverse_legend()
}
