% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_hboxplot.R
\name{gg_hboxplot_facet}
\alias{gg_hboxplot_facet}
\title{Horizontal boxplot ggplot that is facetted.}
\usage{
gg_hboxplot_facet(
  data,
  x_var = NULL,
  y_var,
  facet_var,
  pal = pal_viridis_reorder(1),
  alpha_fill = 0.5,
  alpha_line = 1,
  alpha_point = 1,
  size_line = 0.5,
  size_point = 1.5,
  size_width = 0.5,
  title = NULL,
  title_wrap = 75,
  subtitle = NULL,
  subtitle_wrap = 75,
  x_balance = FALSE,
  x_breaks_n = 2,
  x_expand = c(0, 0),
  x_labels = scales::label_comma(),
  x_title = NULL,
  x_title_wrap = 50,
  x_zero = FALSE,
  x_zero_line = NULL,
  y_expand = ggplot2::waiver(),
  y_labels = snakecase::to_sentence_case,
  y_na_rm = FALSE,
  y_rev = FALSE,
  y_title = NULL,
  y_title_wrap = 50,
  facet_labels = snakecase::to_sentence_case,
  facet_na_rm = FALSE,
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_rev = FALSE,
  facet_scales = "fixed",
  caption = NULL,
  caption_wrap = 75,
  theme = gg_theme(gridlines_v = TRUE),
  stat = "boxplot",
  xmin_var = NULL,
  xlower_var = NULL,
  xmiddle_var = NULL,
  xupper_var = NULL,
  xmax_var = NULL
)
}
\arguments{
\item{data}{An ungrouped summarised tibble or dataframe generally in a structure to be transformed to boxplot statistics (or alternatively in a structure of summary boxplot statistics). Required input.}

\item{x_var}{Unquoted numeric variable to be on the x scale for when stat = "boxplot" is selected.}

\item{y_var}{Unquoted categorical variable to be on the y scale (i.e. character, factor, or logical). Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{pal}{Character vector of hex codes.}

\item{alpha_fill}{The opacity of the fill. Defaults to 0.5.}

\item{alpha_line}{The opacity of the outline. Defaults to 1.}

\item{alpha_point}{The opacity of the outlier points. Defaults to 1.}

\item{size_line}{The size of the outlines of boxplots.}

\item{size_point}{The size of the outlier points. Defaults to 1.5.}

\item{size_width}{Width of boxes. Defaults to 0.5.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 60.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 60.}

\item{x_balance}{For a numeric x variable, add balance to the x scale so that zero is in the centre of the x scale.}

\item{x_breaks_n}{For a numeric or date x variable, the desired number of intervals on the x scale, as calculated by the pretty algorithm. Defaults to 2.}

\item{x_expand}{A vector of range expansion constants used to add padding to the x scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{x_labels}{A function or named vector to modify x scale labels. Use ggplot2::waiver() to keep x labels untransformed.}

\item{x_title}{X scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{x_zero}{For a numeric x variable, TRUE or FALSE of whether the minimum of the x scale is zero. Defaults to FALSE.}

\item{x_zero_line}{For a numeric x variable, TRUE or FALSE whether to add a zero reference line to the x scale. Defaults to TRUE if there are positive and negative values in x_var. Otherwise defaults to FALSE.}

\item{y_expand}{A vector of range expansion constants used to add padding to the y scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{y_labels}{A function or named vector to modify y scale labels. If NULL, categorical variable labels are converted to sentence case. Use ggplot2::waiver() to keep y labels untransformed.}

\item{y_na_rm}{TRUE or FALSE of whether to include y_var NA values. Defaults to FALSE.}

\item{y_rev}{For a categorical variable, TRUE or FALSE of whether the y variable variable is reversed. Defaults to FALSE.}

\item{y_title}{y scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{facet_labels}{A function or named vector to modify facet scale labels. Defaults to converting labels to sentence case. Use ggplot2::waiver() to keep facet labels untransformed.}

\item{facet_na_rm}{TRUE or FALSE of whether to include facet_var NA values. Defaults to FALSE.}

\item{facet_ncol}{The number of columns of facetted plots.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{facet_rev}{TRUE or FALSE of whether the facet variable variable is reversed. Defaults to FALSE.}

\item{facet_scales}{Whether facet_scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 75.}

\item{theme}{A ggplot2 theme.}

\item{stat}{String of "boxplot" or "identity". Defaults to "boxplot".}

\item{xmin_var}{Unquoted numeric variable for minimum of whisker on the x scale for when stat = "identity" is selected.}

\item{xlower_var}{Unquoted numeric variable for minimum of box on the x scale for when stat = "identity" is selected.}

\item{xmiddle_var}{Unquoted numeric variable for middle of box on the x scale for when stat = "identity" is selected.}

\item{xupper_var}{Unquoted numeric variable for maximum of box on the x scale for when stat = "identity" is selected.}

\item{xmax_var}{Unquoted numeric variable for maximum of whisker on the x scale for when stat = "identity" is selected.}
}
\value{
A ggplot object.
}
\description{
Horizontal boxplot ggplot that is facetted, but not coloured.
}
\examples{
library(simplevis)
library(palmerpenguins)

gg_hboxplot_facet(penguins, 
              x_var = body_mass_g, 
              y_var = sex, 
              facet_var = species, 
              y_na_rm = TRUE)

}
