% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_theme.R
\name{gg_theme}
\alias{gg_theme}
\title{Create a simple theme for a graph.}
\usage{
gg_theme(
  font = "",
  font_title = NULL,
  font_subtitle = NULL,
  font_body = NULL,
  size_title = 11,
  size_subtitle = 10,
  size_body = 10,
  size_axis = 0.3,
  size_ticks = 0.3,
  size_gridlines = 0.2,
  style_title = "bold",
  style_subtitle = "plain",
  style_body = "plain",
  pal_title = "#000000",
  pal_subtitle = "#323232",
  pal_body = "#323232",
  pal_axis = "#323232",
  pal_ticks = "#323232",
  pal_background = c("#ffffff", "#ffffff"),
  pal_gridlines = "#D3D3D3",
  gridlines_h = FALSE,
  gridlines_v = FALSE,
  void = FALSE
)
}
\arguments{
\item{font}{The font for all text to use. Defaults to "".}

\item{font_title}{The font for the title. If NULL, inherits from font argument.}

\item{font_subtitle}{The font for the subtitle. If NULL, inherits from font argument.}

\item{font_body}{The font for the subtitle. If NULL, inherits from font argument.}

\item{size_title}{The size of the title font. Defaults to 11.}

\item{size_subtitle}{The size of the subtitle font. Defaults to 10.}

\item{size_body}{The size of all text other than the title or subtitle. Defaults to 10.}

\item{size_axis}{The size of the axis. Defaults to 0.3.}

\item{size_ticks}{The size of the ticks. Defaults to 0.3.}

\item{size_gridlines}{The size of the vertical major gridlines. Defaults to 0.2.}

\item{style_title}{The style of the title font. Defaults to "bold".}

\item{style_subtitle}{The style of the subtitle font. Defaults to "plain".}

\item{style_body}{The style of all text other than the title or subtitle. Defaults to "plain".}

\item{pal_title}{The colour palette for the title font. Defaults to "#000000".}

\item{pal_subtitle}{The colour palette for the subtitle font. Defaults to "#323232".}

\item{pal_body}{The colour palette for all text other than the title or subtitle. Defaults to "#323232".}

\item{pal_axis}{The colour palette for the axis. Defaults to "#323232".}

\item{pal_ticks}{The colour palette for the ticks. Defaults to "#323232".}

\item{pal_background}{A two colour vector. The first colour if for the panel (and legend key). The second colour is for the rest of the background.}

\item{pal_gridlines}{The colour palette for the vertical major gridlines. Defaults to "#D3D3D3".}

\item{gridlines_h}{TRUE or FALSE of whether to show hotizontal gridlines.}

\item{gridlines_v}{TRUE or FALSE of whether to show vertical gridlines.}

\item{void}{TRUE or FALSE of whether to drop all axis lines, ticks and x and y labels. Useful for maps. Defaults to FALSE.}
}
\value{
A ggplot theme.
}
\description{
Create a simple theme for a graph.
}
