% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simplr.R
\name{simplify}
\alias{simplify}
\alias{simplify.call}
\alias{simplify.function}
\alias{simplify.integer}
\alias{simplify.name}
\alias{simplify.numeric}
\alias{simplifyq}
\title{Basic Symbolic Expression Simplification}
\usage{
simplify(sexp)

simplifyq(sexp)

\method{simplify}{call}(sexp)

\method{simplify}{function}(sexp)

\method{simplify}{numeric}(sexp)

\method{simplify}{integer}(sexp)

\method{simplify}{name}(sexp)
}
\arguments{
\item{sexp}{An R object to simplify. See details.}
}
\value{
The simplified expression.
}
\description{
\code{simplify} simplifies \code{sexp} by applying basic algebraic
simplification rules.
\code{simplifyq} quotes its argument, i.e. \code{simplifyq(X)} is
equivalent to \code{simplify(quote(X))}.
}
\details{
\code{simplify} is a S3 generic method with support for objects of class
\code{numeric}, \code{integer}, \code{name}, \code{call}, and
\code{function}.
SimplR uses code from the Ev3 computer algebra system to implement
expression simplification. The following simplification steps are
performed:
\itemize{
  \item consolidate product coefficients
  \item distribute coefficients over sums
  \item convert differences to sums
  \item simplify constants
  \item simplify products
  \item compact linear parts
  \item simplify trigonometrics
}
}
\examples{
simplifyq(3*2+1)              #=> 7

simplifyq(1 * x)              #=> x
simplifyq(x / x)              #=> 1
simplifyq(x - x)              #=> 0
simplifyq(x + 1 - 1)          #=> x

simplifyq(f(x) + f(x) + y)    #=> y + 2 * f(x)
simplifyq(sin(x)^2+cos(x)^2)  #=> 1

simplify(function(a,b) a + a + 3 * f(b) * 5 / f(b))
#=> function(a, b) 15 + 2 * a
}
\seealso{
\url{http://www.lix.polytechnique.fr/~liberti/Ev3.pdf}
}

