% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bisimrel.R
\name{bisimrel}
\alias{bisimrel}
\title{Simulation of Multivariate Linear Model data with response}
\usage{
bisimrel(n = 50, p = 100, q = c(10, 10, 5), rho = c(0.8, 0.4),
  relpos = list(c(1, 2), c(2, 3)), gamma = 0.5, R2 = c(0.8, 0.8),
  ntest = NULL, muY = NULL, muX = NULL, sim = NULL)
}
\arguments{
\item{n}{Number of training samples}

\item{p}{Number of x-variables}

\item{q}{Vector of number of relevant predictor variables for first, second and common to both responses}

\item{rho}{A 2-element vector, unconditional and conditional correlation between y_1 and y_2}

\item{relpos}{A list of position of relevant component for predictor variables. The list contains vectors of position index, one vector or each response}

\item{gamma}{A declining (decaying) factor of eigen value of predictors (X). Higher the value of \code{gamma}, the decrease of eigenvalues will be steeper}

\item{R2}{Vector of coefficient of determination for each response}

\item{ntest}{Number of test observation}

\item{muY}{Vector of average (mean) for each response variable}

\item{muX}{Vector of average (mean) for each predictor variable}

\item{sim}{A simrel object for reusing parameters setting}
}
\value{
A simrel object with all the input arguments along with following additional items
    \item{X}{Simulated predictors}
    \item{Y}{Simulated responses}
    \item{beta}{True regression coefficients}
    \item{beta0}{True regression intercept}
    \item{relpred}{Position of relevant predictors}
    \item{testX}{Test Predictors}
    \item{testY}{Test Response}
    \item{minerror}{Minimum model error}
    \item{Rotation}{Rotation matrix of predictor (R)}
    \item{type}{Type of simrel object, in this case \emph{bivariate}}
    \item{lambda}{Eigenvalues of predictors}
    \item{Sigma}{Variance-Covariance matrix of response and predictors}
}
\description{
Simulation of Multivariate Linear Model data with response
}
\examples{
sobj <- bisimrel(
   n = 100,
   p = 10,
   q = c(5, 5, 3),
   rho = c(0.8, 0.4),
   relpos = list(c(1, 2, 3), c(2, 3, 4)),
   gamma = 0.7,
   R2 = c(0.8, 0.8)
)
# Regression Coefficients from this simulation
sobj$beta
}
\references{
Sæbø, S., Almøy, T., & Helland, I. S. (2015). simrel—A versatile tool for linear model data simulation based on the concept of a relevant subspace and relevant predictors. Chemometrics and Intelligent Laboratory Systems, 146, 128-135.

Almøy, T. (1996). A simulation study on comparison of prediction methods when only a few components are relevant. Computational statistics & data analysis, 21(1), 87-107.
}
\keyword{data}
\keyword{linear}
\keyword{model}
\keyword{model,}
\keyword{simulation,}
