% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-functions.R
\name{plot_beta}
\alias{plot_beta}
\title{Plotting Functions}
\usage{
plot_beta(obj, base_theme = theme_grey, lab_list = NULL,
  theme_list = NULL)
}
\arguments{
\item{obj}{A simrel object}

\item{base_theme}{Base ggplot theme to apply}

\item{lab_list}{List of labs arguments such as x, y, title, subtitle}

\item{theme_list}{List of theme arguments to apply in the plot}
}
\value{
A plot of true regression coefficients for the simulated data
}
\description{
Plotting Functions
}
\examples{
sobj <- multisimrel()
sobj \%>\%
    plot_beta(
        base_theme = ggplot2::theme_bw,
        lab_list = list(
            title = "Regression Coefficients",
            subtitle = "From Simulation",
            y = "True Regression Coefficients"
        ),
        theme_list = list(
            legend.position = "bottom"
        )
    )
}
