\name{summaryPopulation}
\alias{summaryPopulation}
\title{
	Summarize the population model used for data generation underlying a result object
}
\description{
	Summarize the population model used for data generation underlying a result object
}
\usage{
summaryPopulation(object)
}
\arguments{
  \item{object}{
	The result object that you wish to extract the data generation population model from (\code{linkS4class{SimResult}}).
}
}
\value{
	A \code{data.frame} contianing the summary of population model across replications.
}
\author{
    Sunthud Pornprasertmanit (University of Kansas; \email{psunthud@ku.edu})
}
\seealso{
	\itemize{
		\item \code{\linkS4class{SimResult}} for result object
	}
}
\examples{
\dontrun{
loading <- matrix(0, 6, 1)
loading[1:6, 1] <- NA
LY <- bind(loading, "runif(1, 0.4, 0.9)")
RPS <- binds(diag(1))
RTE <- binds(diag(6))
CFA.Model <- model(LY = LY, RPS = RPS, RTE = RTE, modelType="CFA")

# We will use only 10 replications to save time.
# In reality, more replications are needed.
Output <- sim(10, n=200, model=CFA.Model)

# Get the summary of population model
summaryPopulation(Output)
}
}
