% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimData.R
\name{trimData}
\alias{trimData}
\title{Trim longitudinal data file once an event has occurred}
\usage{
trimData(dtOld, seqvar, eventvar, idvar = "id")
}
\arguments{
\item{dtOld}{name of data table to be trimmed}

\item{seqvar}{string referencing column that indexes the sequence or period}

\item{eventvar}{string referencing event data column}

\item{idvar}{string referencing id column}
}
\value{
an updated data.table removes all rows folloing the first event for each 
individual
}
\description{
Trim longitudinal data file once an event has occurred
}
\examples{
eDef <- defDataAdd(varname = "e", formula = "u==4", dist = "nonrandom")

P <- t(matrix(c( 0.4, 0.3, 0.2, 0.1,
                 0.0, 0.4, 0.3, 0.3,
                 0.0, 0.0, 0.5, 0.5,
                 0.0, 0.0, 0.0, 1.0),
              nrow = 4))

dp <- genMarkov(n = 100, transMat = P, 
                chainLen = 8, id = "id", 
                pername = "period",
                varname = "u")

dp <- addColumns(eDef, dp)
dp <- trimData(dp, seqvar = "period", eventvar = "e", idvar = "id")

dp

}
