% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{genOrdCat}
\alias{genOrdCat}
\title{Generate ordinal categorical data}
\usage{
genOrdCat(
  dtName,
  adjVar = NULL,
  baseprobs,
  catVar = "cat",
  asFactor = TRUE,
  idname = "id",
  prefix = "grp",
  rho = 0,
  corstr = "ind",
  corMatrix = NULL
)
}
\arguments{
\item{dtName}{Name of complete data set}

\item{adjVar}{Adjustment variable  name in dtName - determines
logistic shift. This is specified assuming a cumulative logit
link.}

\item{baseprobs}{Baseline probability expressed as a vector or matrix of
probabilities. The values (per row) must sum to <= 1. If \code{rowSums(baseprobs) < 1}, an additional category is added with probability \code{1 - rowSums(baseprobs)}. The number of rows represents the number of new
categorical variables. The number of columns represents the number of
possible responses - if an particular category has fewer possible responses,
assign zero probability to non-relevant columns.}

\item{catVar}{Name of the new categorical field. Defaults to "cat". Can be a
character vector with a name for each new variable defined via \code{baseprobs}.
Will be overridden by \code{prefix} if more than one variable is defined and
\code{length(catVar) == 1}.}

\item{asFactor}{If \code{asFactor == TRUE} (default), new field is returned
as a factor. If \code{asFactor == FALSE}, new field is returned as an integer.}

\item{idname}{Name of the id column in \code{dtName}.}

\item{prefix}{A string. The names of the new variables will be a
concatenation of the prefix and a sequence of integers indicating the
variable number.}

\item{rho}{Correlation coefficient, -1 < rho < 1. Use if corMatrix is not
provided.}

\item{corstr}{Correlation structure of the variance-covariance matrix defined
by sigma and rho. Options include "ind" for an independence structure, "cs"
for a compound symmetry structure, and "ar1" for an autoregressive structure.}

\item{corMatrix}{Correlation matrix can be entered directly. It must be
symmetrical and positive definite. It is not a required field; if a matrix is
not provided, then a structure and correlation coefficient rho must be
specified. (The matrix created via \code{rho} and \code{corstr} must also be positive
definite.)}
}
\value{
Original data.table with added categorical field.
}
\description{
Ordinal categorical data is added to an existing data set.
Correlations can be added via correlation matrix or \code{rho} and \code{corstr}.
}
\examples{
# Ordinal Categorical Data ----

def1 <- defData(
    varname = "male",
    formula = 0.45, dist = "binary", id = "idG"
)
def1 <- defData(def1,
    varname = "z",
    formula = "1.2*male", dist = "nonrandom"
)
def1

## Generate data

set.seed(20)

dx <- genData(1000, def1)

probs <- c(0.40, 0.25, 0.15)
dx <- genOrdCat(dx,
  adjVar = "z", idname = "idG", baseprobs = probs,
  catVar = "grp"
)
dx

# Correlated Ordinal Categorical Data ----

baseprobs <- matrix(c(
    0.2, 0.1, 0.1, 0.6,
    0.7, 0.2, 0.1, 0,
    0.5, 0.2, 0.3, 0,
    0.4, 0.2, 0.4, 0,
    0.6, 0.2, 0.2, 0
),
nrow = 5, byrow = TRUE
)

set.seed(333)
dT <- genData(1000)

dX <- genOrdCat(dT,
    adjVar = NULL, baseprobs = baseprobs,
    prefix = "q", rho = .125, corstr = "cs", asFactor = FALSE
)
dX

dM <- data.table::melt(dX, id.vars = "id")
dProp <- dM[, prop.table(table(value)), by = variable]
dProp[, response := c(1:4, 1:3, 1:3, 1:3, 1:3)]

data.table::dcast(dProp, variable ~ response,
    value.var = "V1", fill = 0
)
}
\concept{categorical}
\concept{correlated}
\concept{generate_data}
