% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_data.R
\name{defSurv}
\alias{defSurv}
\title{Add single row to survival definitions}
\usage{
defSurv(
  dtDefs = NULL,
  varname,
  formula = 0,
  scale = 1,
  shape = 1,
  transition = 0
)
}
\arguments{
\item{dtDefs}{Definition data.table to be modified}

\item{varname}{Variable name}

\item{formula}{Covariates predicting survival}

\item{scale}{Scale parameter for the Weibull distribution.}

\item{shape}{The shape of the Weibull distribution. Shape = 1 for
an exponential distribution}

\item{transition}{An integer value indicating the starting point for a new
specification of the hazard function. It will default to 0 (and must be 0)
for the first instance of a "varname".}
}
\value{
A data.table named dtName that is an updated data definitions table
}
\description{
Add single row to survival definitions
}
\examples{
# Baseline data definitions

def <- defData(varname = "x1", formula = .5, dist = "binary")
def <- defData(def, varname = "x2", formula = .5, dist = "binary")
def <- defData(def, varname = "grp", formula = .5, dist = "binary")

# Survival data definitions

sdef <- defSurv(
  varname = "survTime", formula = "1.5*x1",
  scale = "grp*50 + (1-grp)*25", shape = "grp*1 + (1-grp)*1.5"
)

sdef <- defSurv(sdef, varname = "censorTime", scale = 80, shape = 1)

sdef

# Baseline data definitions

dtSurv <- genData(300, def)

# Add survival times

dtSurv <- genSurv(dtSurv, sdef)

head(dtSurv)
}
\concept{define_data}
