% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gts.R
\name{unitConversion}
\alias{unitConversion}
\title{Convert Unit of Time Series Data}
\usage{
unitConversion(x, from.unit, to.unit)
}
\arguments{
\item{x}{A \code{vector} containing the values on x-axis.}

\item{from.unit}{A \code{string} indicating the unit which the data is converted from.}

\item{to.unit}{A \code{string} indicating the unit which the data is converted to.}
}
\value{
A \code{list} with the following structure:
\describe{
 \item{x}{Data}
 \item{converted}{A \code{boolean} indicating whether conversion is made}
}
}
\description{
Manipulate the units of time to different ones
}
\details{
The supported units are "ns"(nanosecond), "ms"(millisecond), "sec", "min", "hour", "day", "month", and "year".
Make sure \code{from.unit} and \code{to.unit} are not \code{NULL} before it is passed to this function.
}
\examples{
x = seq(60, 3600, 60)
unitConversion(x, 'sec', 'min')
y = 1:10
unitConversion(y, 'hour', 'sec')
}
\keyword{internal}
