% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/process_to_wv.cpp, src/process_to_wv.h
\name{ar1_to_wv}
\alias{ar1_to_wv}
\title{AR(1) process to WV}
\usage{
ar1_to_wv(phi, sigma2, tau)
}
\arguments{
\item{phi}{A \code{double} that is the phi term of the AR(1) process}

\item{sigma2}{A \code{double} corresponding to variance of AR(1) process}

\item{tau}{A \code{vec} containing the scales e.g. \eqn{2^{\tau}}{2^tau}}
}
\value{
A \code{vec} containing the wavelet variance of the AR(1) process.
}
\description{
This function computes the Haar WV of an AR(1) process
}
\details{
This function is significantly faster than its generalized counter part
\code{\link{arma_to_wv}}.
}
\section{Process Haar Wavelet Variance Formula}{

The Autoregressive Order \eqn{1} (AR(\eqn{1})) process has a Haar Wavelet Variance given by:
\deqn{\frac{{2{\sigma ^2}\left( {4{\phi ^{\frac{{{\tau _j}}}{2} + 1}} - {\phi ^{{\tau _j} + 1}} - \frac{1}{2}{\phi ^2}{\tau _j} + \frac{{{\tau _j}}}{2} - 3\phi } \right)}}{{{{\left( {1 - \phi } \right)}^2}\left( {1 - {\phi ^2}} \right)\tau _j^2}}}{(2*sigma2)/((1-phi)^2*(1-phi^2)*tau[j]^2)*(4*phi^(tau[j]/2 + 1) - phi^(tau[j]+1) - .5 * phi^2 * tau[j] + tau[j]/2 - 3*phi)}
}

