% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/gen_process.cpp, src/gen_process.h
\name{gen_arima}
\alias{gen_arima}
\title{Generate Autoregressive Order p, Integrated d, Moving Average Order q (ARIMA(p,d,q)) Model}
\usage{
gen_arima(N, ar, d, ma, sigma2 = 1.5, n_start = 0L)
}
\arguments{
\item{N}{An \code{integer} for signal length.}

\item{ar}{A \code{vec} that contains the AR coefficients.}

\item{d}{An \code{integer} that indicates a difference.}

\item{ma}{A \code{vec} that contains the MA coefficients.}

\item{sigma2}{A \code{double} that contains process variance.}

\item{n_start}{An \code{unsigned int} that indicates the amount of observations to be used for the burn in period.}
}
\value{
A \code{vec} that contains the generated observations.
}
\description{
Generate an ARIMA(p,d,q) process with supplied vector of Autoregressive Coefficients (\eqn{\phi}), Integrated \eqn{d}{d}, Moving Average Coefficients (\eqn{\theta}), and \eqn{\sigma^2}.
}
\details{
The innovations are generated from a normal distribution.
The \eqn{\sigma^2} parameter is indeed a variance parameter. 
This differs from R's use of the standard deviation, \eqn{\sigma}.
}
\section{Warning}{

Please note, this function will generate a sum of \eqn{N + d} number of observations,
where \eqn{d} denotes the number of differences necessary.
}

\keyword{internal}
